<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	パスワード作成・変更処理
	Password making and change processing

  	passwd.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2009 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);
$mode = get_post_get_val("mode");

$update = get_post_get_val("update");

$userid = get_post_get_val("userid");
$passwd = get_post_get_val("passwd");
$passwd1 = get_post_get_val("passwd1");
$passwd2 = get_post_get_val("passwd2");

$s_name = files_session_name();
$s_id = session_id();

$login_user = get_login_user();

if ($conf["PASSWD_SCRIPT"] != "") {
	$scriptname = $conf["PASSWD_SCRIPT"];
} else {
	$scriptname = "passwd.php";
}
if ($conf["PASSWD_FILE"] != "") {
	$pwdfile = $conf["PASSWD_FILE"];
} else {
	$pwdfile = "passwd";
}

$title_str = get_txt("password setting");
$userid_str = get_txt("user id");
$passwd_str = get_txt("password");
$passwd_str2 = get_txt("re-input password");
$submit_str = get_txt("apply");
$reset_str = get_txt("reset");

$return_url = get_post_get_val("return_url");
$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

if ($mode != "send") {
	//パスワード設定フォーム表示
	//Password setting and form displays

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
<SCRIPT LANGUAGE="JavaScript" SRC="md5hash.js"></SCRIPT>
<SCRIPT LANGUAGE="JavaScript">
<!--
function CheckPasswd() {
	pwd1 = document.passwd_form.passwd1.value;
	pwd2 = document.passwd_form.passwd2.value;

	if (pwd1 != pwd2) {
		alert("<?php echo get_txt("unmatch password"); ?>");
		return false;
	} else {
<?php
if (is_md5_use($conf)) {
?>
		if (pwd1 == "") {
			pwd2 = "";
		} else {
			pwd2 = md5hash_hexstr(pwd1);
		}
<?php
} else {
?>
		//When you do not use the MD5 hush
		pwd2 = pwd1;
<?php
}
?>
		document.passwd_form.passwd1.value = "";
		document.passwd_form.passwd2.value = "";
		document.passwd_form.passwd.value=pwd2;
		document.passwd_form.update.value="update";
		//document.passwd_form.submit();
		return true;
	}
}
// -->
</SCRIPT>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
	//ページヘッダーHTMLを取得
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<HR>
<?php
	//前のページに戻るのHTML文字列を取得
	//The HTML string to return to the previous page is acquired.
	echo get_return_prev_page_HTML($conf, $return_url, "");
?>
<br>
<CENTER>
<form name="passwd_form" action="<?php echo $scriptname ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="passwd" value="">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="return_url" value="<?php echo $return_url ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER><B><?php echo $title_str ?></B></CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo $userid_str ?>&nbsp;:&nbsp;</B></TD>
			<TD><input name="userid" type="text" size=20 maxlength=30
									value="<?php echo $login_user ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo $passwd_str ?>&nbsp;:&nbsp;</B></TD>
			<TD><input name="passwd1" type="password" size=20 maxlength=30></TD>
		</TR>
		<TR>
			<TD><B><?php echo $passwd_str2 ?>&nbsp;:&nbsp;</B></TD>
			<TD><input name="passwd2" type="password" size=20 maxlength=30></TD>
		</TR>
		<TR>
			<TD colspan=2>
			<CENTER>
			<input type="submit" onClick="return CheckPasswd()" value="<?php echo $submit_str ?>">
			<input type="reset" value="<?php echo $reset_str ?>">
			<input type="hidden" name="update" value="">
			</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>
<HR>

<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);

} else {
	//ログイン実行
	//Login execution
	$msg = "";
	$sts = FALSE;
	$fp = 0;

	if ($userid == "") {
		//ユーザーID未設定
		//User ID unsetting
		$msg .= $userid_str . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "Password change failure : no user id");
	} elseif (isset($login_user) && $userid != $login_user &&
							$login_user != $conf["ADMIN_USERID"]) {
		//管理者でなくログインユーザー以外のユーザーIDを指定した場合
		//When the user who is not the manager changes the setting of the user
		$msg .= get_txt("cannot set another user password");
		put_log($conf, "Password change " . $userid .
									" failure : no admin user");
	} elseif(! file_exists($pwdfile)) {
		$msg .= get_txt("no password file");
		put_log($conf, "Password change " . $userid .
									" failure : no password file");
	} elseif (!($fp = fopen ($pwdfile, "r"))) {
		$msg .= get_txt("cannot open password file");
		put_log($conf, "Password change " . $userid .
									" failure : can not open password file");
	} else {
		flock($fp, 2);

		$pwdarr = array();

		if (isset($passwd) && $passwd != "") {
			$cryptpwd = $passwd;
			if (!is_md5_use($conf)) {
				//入力でMD5を使用していない場合は、ここでハッシュ化する
				//When MD5 is not used by the input, it makes it to the 
				//hush here.
				$cryptpwd = md5($passwd);
			}
		} else {
			$cryptpwd = "";
		}
		$found = FALSE;

		$idx = 0;
		while (!feof($fp)) {
			//１行読み込み
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if ($buffer == "") {
				//空行は捨てる
				//The null line is thrown away.
				continue;
			} elseif (strlen($buffer) < 3) {
				//３文字以下の行はそのまま出力
				//The line of three characters or less is
				//output as it is.
				$pwdarr[$idx] = $buffer;
				$idx++;
			} elseif (substr($buffer, 0, 1) == "#") {
				//コメント行はそのまま出力
				//The comment line is output as it is.
				$pwdarr[$idx] = $buffer;
				$idx++;
			} else {
				//行をＴＡＢで分割
				//The line is divided with TAB.
				$flds = split("\t", $buffer);

				if ($flds[0] != "") {
					if ($userid == $flds[0]) {
						$pwdarr[$idx] = $userid . "\t" . $cryptpwd;
						$found = TRUE;
					} else {
						if (isset($flds[1]) && $flds[1] != "") {
							$pwdarr[$idx] = $flds[0] . "\t" . $flds[1];
						} else {
							$pwdarr[$idx] = $flds[0] . "\t";
						}
					}
				} else {
					$pwdarr[$idx] = $buffer;
				}
				$idx++;
			}
		}
		if (!$found) {
			$pwdarr[$idx] = $userid . "\t" . $cryptpwd;
		}
		flock($fp, 3);
		fclose($fp);

		if (!($fp = fopen ($pwdfile, "w"))) {
			$msg .= get_txt("cannot open password file");
			put_log($conf, "Password change " . $userid .
								" failure : can not open password file");
		} else {
			flock($fp, 2);
			foreach($pwdarr as $pwd_line) {
				fputs($fp, "$pwd_line\n");
			}

			flock($fp, 3);
			fclose($fp);
			chmod($pwdfile, get_pwd_file_attr($conf));

			$msg = $userid_str . "&nbsp;:&nbsp;";
			$msg .= $userid . "&nbsp;:&nbsp;" . 
							get_txt("password set complete");
			$sts = TRUE;
			put_log($conf, "Password change success : " . $userid);
		}
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<CENTER>
<TABLE border=0>
	<TR>
		<TD>
			<CENTER>
				<?php
					//ページタイトルのイメージまたは文字列
					//Image or character string in page title
					echo get_page_title_HTML($conf);
				?>
			</CENTER>
		</TD>
	</TR>
</TABLE>
<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);
?>
<HR>

<?php
	echo $msg . "<BR>\n";
	echo "<HR>";

	$return_url = get_post_get_val("return_url");

	if ($return_url != "") {
		$return_url .= "?config=" . $conf["config"];
		$return_url .= "&" . $s_name . "=" . $s_id;

		//元のＵＲＬに戻るのHTML文字列を取得
		//HTML that returns to former URL is acquired.
		echo get_return_refer_url_HTML($return_url, get_txt("back"));
	} else {
		//ファイル一覧に戻るのHTML文字列を取得
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
	}
	echo "<HR>";

	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);
}

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>

</CENTER>
</BODY>
</HTML>
