<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダの新規作成処理
	New making processing of common folder

  	newconf.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2009 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.5
		戻り先URLが正しくセットされなかったので修正した。
		Because return destination URL had not been correctly set, it corrected it. 

		ファイルへの直接リンク用の設定項目を追加した
		I added a setting item for direct links to the file.

	Ver.2.1
		configファイルとは別のディレクトリにindex.phpを作成するようにした
		I made index.php in another directory with the config file

		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$scriptname = "newconf.php";

$submit = get_post_get_val("submit");
$mode = get_post_get_val("mode");
$return_url = get_post_get_val("return_url");

$s_name = files_session_name();
$s_id = session_id();

$script_dir = ".";

$new_name = "new_dir";

$top_dir = $conf["TOPDIR"] . "/" . $new_name;

$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
//ページヘッダーHTMLを取得
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>

<?php

if ($mode != "send") {
	//新規フォルダ設定フォーム表示
	//New folder setting and form displays
	$returl1 = get_entry_page_top_dir($conf) . "/" . $new_name . "/";
	$returl1_title = get_txt("login page");
	$returl2 = "/";
	$returl2_title = get_txt("top page");

?>

<form action="<?php echo $conf["NEWCONF_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="return_url" value="<?php echo $return_url ?>">
	<input type="hidden" name="<?php echo $s_name ?>"
								value="<?php echo $s_id ?>">
	<TABLE border=0><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER><B><?php echo get_txt("create shared folder"); ?></B></CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><font color="#ff0000"><?php echo get_txt("config name"); ?>
					</font></B></TD>
			<TD><input name="config_name" type="text" size=30
						maxlength=60 value="<?php echo $new_name; ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("page title"); ?></B></TD>
			<TD><input name="title" type="text" size=40
				maxlength=80 value="<?php echo get_txt("shared folder"); ?>">
			</TD>
		</TR>
		<TR>
			<TD><B><font color="#ff0000">
				<?php echo get_txt("top folder full path"); ?>
				</font></B></TD>
			<TD><input name="topdir" type="text" size=80 
						maxlength=128 value="<?php echo $top_dir ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("top folder url"); ?></B></TD>
			<TD><input name="topurl" type="text" size=80 
						maxlength=128 value=""></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("return url1"); ?></B></TD>
			<TD><input name="returl1" type="text" size=80 maxlength=128
									value="<?php echo $returl1; ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("return url1 title"); ?></B></TD>
			<TD><input name="returl1_title" type="text" size=40 maxlength=80
								value="<?php echo $returl1_title; ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("return url2"); ?></B></TD>
			<TD><input name="returl2" type="text" size=80 maxlength=128
									value="<?php echo $returl2; ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("return url2 title"); ?></B></TD>
			<TD><input name="returl2_title" type="text" size=40 maxlength=80
								value="<?php echo $returl2_title; ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("no auth caller url"); ?></B></TD>
			<TD><input name="caller_url" type="text" size=80
									maxlength=128 value=""></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("max upload size"); ?></B></TD>
			<TD><input name="max_upload_size" type="text" size=14
									maxlength=12 value="10">
				<input name="upload_size_unit" type="radio" value="1">KB
				<input name="upload_size_unit" type="radio" value="2" checked>MB
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("max use capacity"); ?>
				&nbsp;:&nbsp;</B></TD>
			<TD><input name="max_total_size" type="text" size=14
									maxlength=12 value="100">
				<input name="total_size_unit" type="radio" value="1">KB
				<input name="total_size_unit" type="radio" value="2" checked>MB
				<input name="total_size_unit" type="radio" value="3">GB
			</TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" name="submit"
								value="<?php echo get_txt("create"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				</CENTER>
			</TD>
		</TR>
		<TR><TD colspan=2>&nbsp;</TD></TR>
		<TR>
			<TD colspan=2>
				<B><font color="#ff0000">
					<?php echo get_txt("top folder url_caution"); ?>
				</font></B>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>

<?php

} else {
	//フォルダ作成処理
	//Folder making processing
	$msg = "";
	$sts = TRUE;
	$lock_fp = FALSE;
	$config_file = "";
	$new_conffile = "";
	$new_conf = array();

	if ($submit == "") {
		$sts = FALSE;
	} else {
		// 設定名
		//Set name
		$config_name = get_post_get_val("config_name");
		$topdir = get_post_get_val("topdir");
		$title = get_post_get_val("title");

		if ($config_name == "") {
			$msg .= get_txt("config name is not specified") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Create new folder failure : no config name");
		}
		if ($sts && $topdir == "") {
			$msg .= get_txt("top folder is not specified") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Create new folder " . $config_name .
										" failure : no top folder path");
		}
		if ($sts && $title == "") {
			$msg .= get_txt("title is not specified") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Create new folder " . $config_name .
											" failure : no title");
		}
		if ($sts) {
			$topurl = get_post_get_val("topurl");
			$returl1 = get_post_get_val("returl1");
			$returl1_title = get_post_get_val("returl1_title");
			$returl2 = get_post_get_val("returl2");
			$returl2_title = get_post_get_val("returl2_title");
			$caller_url = get_post_get_val("caller_url");
			$max_upload_size = get_post_get_val("max_upload_size");
			$max_total_size = get_post_get_val("max_total_size");
			$upload_size_unit = get_post_get_val("upload_size_unit");
			$total_size_unit = get_post_get_val("total_size_unit");

			//指定の単位からバイト単位に変換する
			if ($upload_size_unit == 1) {
				$max_upload_size *= 1000;
			} else if ($upload_size_unit == 2) {
				$max_upload_size *= (1000 * 1000);
			}
			//指定の単位からバイト単位に変換する
			if ($total_size_unit == 1) {
				$max_total_size *= 1000;
			} else if ($total_size_unit == 2) {
				$max_total_size *= (1000 * 1000);
			} else if ($total_size_unit == 3) {
				$max_total_size *= (1000 * 1000 * 1000);
			}

			// 設定ディレクトリ
			//Set directory
			$config_dir = get_conf_top_dir($conf) . "/" . $config_name;

			$entry_page_top_dir = get_entry_page_top_dir($conf);

			$entry_page_dir = $entry_page_top_dir . "/" . $config_name;

			// 設定ファイル名
			//Configuration file name
			$config_file = $config_name . ".conf";

			// パスワードファイル名
			//Password file name
			$passwd_file =  "passwd";

			// 設定ファイルのフルパス
			//Full path of configuration file
			$new_conffile = make_path($config_dir, "", $config_file);

			// パスワードファイルのフルパス
			//Full path of password file
			$passwd_file = make_path($config_dir, "", $passwd_file);

			// 設定内容を新しい設定にコピーする
			//A set content is copied onto a new setting.
			$new_conf = $conf;

			// 管理用の設定ファイルではないので 0 をセット
			//Because it is not a configuration file for management, 0 is set.
			$new_conf["CONFIG_DIR"] = 0;

			$new_conf["TOPDIR"] = $topdir;

			$new_conf["TOPURL"] = $topurl;

			$new_conf["HEADER_TITLE"] = $title;
			$new_conf["TITLESTR"] = $title;

			$new_conf["TITLEIMG"] = "";

			$new_conf["RETURL1"] = $returl1;
			$new_conf["returntitle1"] = $returl1_title;

			$new_conf["RETURL2"] = $returl2;
			$new_conf["returntitle2"] = $returl2_title;

			$new_conf["CALLER_URL"] = $caller_url;

			if ($max_upload_size != "") {
				$new_conf["MAX_UPLOAD_SIZE"] = $max_upload_size;
			}
			if ($max_total_size != "") {
				$new_conf["MAX_TOTAL_SIZE"] = $max_total_size;
			}
			//$new_conf["CUTDIR"] = $new_conf["TOPDIR"] . "/.cutbuf";
			$new_conf["CUTDIR"] = ".cutbuf";
			$new_conf["PASSWD_FILE"] = $passwd_file;
			$new_conf["config"] = $new_conffile;
		}
		if ($sts) {
			// 設定ディレクトリの有無を確認
			//The presence of a set directory is confirmed.
			if (!file_exists($config_dir)) {
				//無ければディレクトリ作成
				//It makes it the directory in case of not being.
				$sts = make_dir($config_dir, get_conf_dir_attr($conf));
				if (!$sts) {
					$msg .= get_txt("cannot make config folder") . "<br>\n";
					put_log($conf, "Create new folder " . $config_name .
								" failure : can not create config folder");
				}
				if (! chmod($config_dir, get_conf_dir_attr($conf))) {
					put_log($conf, "chmod config dir " .
									$config_dir .
									" failure : chmod config dir");
				}
			}
		}
		if ($sts) {
			if (!file_exists($entry_page_top_dir)) {
				//無ければディレクトリ作成
				//It makes it the directory in case of not being.
				$sts = make_dir($entry_page_top_dir, get_conf_dir_attr($conf));
				if (!$sts) {
					$msg .= get_txt("cannot make config folder") . "<br>\n";
					put_log($conf, "Create new folder " . $entry_page_top_dir .
								" failure : can not create config folder");
				}
				if (! chmod($entry_page_top_dir, get_conf_dir_attr($conf))) {
					put_log($conf, "chmod entry page top dir " .
									$entry_page_top_dir .
									" failure : chmod entry page top dir");
				}
			}
		}
		if ($sts) {
			if (!file_exists($entry_page_dir)) {
				//無ければディレクトリ作成
				//It makes it the directory in case of not being.
				$sts = make_dir($entry_page_dir, get_conf_dir_attr($conf));
				if (!$sts) {
					$msg .= get_txt("cannot make config folder") . "<br>\n";
					put_log($conf, "Create new folder " . $entry_page_dir .
								" failure : can not create config folder");
				}
				if (! chmod($entry_page_dir, get_conf_dir_attr($conf))) {
					put_log($conf, "chmod entry page dir " . $entry_page_dir .
									" failure : chmod entry page dir");
				}
			}
		}
		if ($sts) {
			if (file_exists($new_conffile)) {
				rename($new_conffile, $new_conffile . ".old");
			}
		}
		//ロックする
		//It locks.
		$lockfile = make_path($config_dir, "", $conf["LOCKFILE"]);
		$lock_fp = lock_files($lockfile);
		if (! $lock_fp) {
			$msg .= get_txt("cannot lock") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Create new folder " . $config_name .
									" failure : can not lock config folder");
		}
		if ($sts) {
			$sts = write_conf_file($conf, $new_conf, $new_conffile);
			if (!$sts) {
				$msg .= get_txt("cannot create config file") . "<br>\n";
				put_log($conf, "Create new folder " . $config_name .
								" failure : can not create config file : " .
								$new_conffile);
			}
			if (! chmod($new_conffile, get_conf_file_attr($conf))) {
				put_log($conf, "chmod new folder " . $new_conffile .
								" failure : chmod config file");
			}
		}
		if ($sts) {
			$srcfile = make_path($script_dir, "", "index.php");
			if (file_exists($srcfile)) {
				$dstfile = make_path($entry_page_dir, "", "index.php");
				$srchstr = "config=";
				$replace = "\$url = \"" . $conf["SCRIPT_DIR_URL"];
				$replace .= "/" . $conf["LOGIN_SCRIPT"];
				$replace .= "?config=" . conv_url_code($new_conffile) . "\";";

				$sts = replace_line_file_copy($srcfile, $dstfile, 
													$srchstr, $replace);
				if (!$sts) {
					$msg .= get_txt("cannot copy index.php") . "<br>\n";
					put_log($conf, "Create new file " . $config_name .
										" failure : can not copy index.php");
				} else {
					chmod($dstfile, get_conf_file_attr($conf));
				}
			}
		}
		if ($sts) {
			if (file_exists($passwd_file)) {
				rename($passwd_file, $passwd_file . ".old");
			}
		}
		if ($sts) {
			if (!($fp = fopen ($passwd_file, "w"))) {
				$msg .= get_txt("cannot create password file") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Create new folder " . $config_name .
								" failure : can not create password file");
			} else {
				$default_passwd = "";
				if ($new_conf["ADMIN_DEFAULT_PASSWD"] != "") {
					$default_passwd = md5($new_conf["ADMIN_DEFAULT_PASSWD"]);
				}
				$str = $new_conf["ADMIN_USERID"] . "\t" . $default_passwd;
				fputs($fp, "$str\n");
			}
			fclose($fp);
			chmod($passwd_file, get_pwd_file_attr($conf));
		}
		if ($sts) {
			// 先頭ディレクトリの有無を確認
			//The presence of the first directory is confirmed.
			if (!file_exists($new_conf["TOPDIR"])) {
				//無ければディレクトリ作成
				//It makes it the directory in case of not being.
				$sts = make_dir($new_conf["TOPDIR"], get_data_dir_attr($conf));
				if (!$sts) {
					$msg .= get_txt("cannot make top folder") . "&nbsp;(";
					$msg .= $new_conf["TOPDIR"];
					$msg .= ")<br>\n";
					put_log($conf, "Create new folder " . $config_name .
									" failure : can not create data folder");
				} else {
					chmod($new_conf["TOPDIR"], get_data_dir_attr($conf));
				}
			}
		}
		if ($sts) {
			$cutdir = make_path($new_conf["TOPDIR"], $new_conf["CUTDIR"], "");

			// カットバッファ・ディレクトリの有無を確認
			//The presence of the cutting buffer directory is confirmed.
			if (!file_exists($cutdir)) {
				//無ければディレクトリ作成
				//It makes it the directory in case of not being.
				$sts = make_dir($cutdir, get_data_dir_attr($conf));
				if (!$sts) {
					$msg .= get_txt("cannot make cut buffer folder") .
								"&nbsp;(" . $cutdir . ")<br>\n";
					put_log($conf, "Create new folder " . $config_name .
									" failure : can not create cut buffer");
				} else {
					chmod($cutdir, get_data_dir_attr($conf));
				}
			}
		}
		//ロックを解除する
		//The lock is released.
		unlock_files($lock_fp, $lockfile);

		if ($sts) {
			put_log($conf, "Create new folder " . $config_name . " success");

			//ファイル一覧にリダイレクトする
			//It redirects it to the file list.
			//echo get_redirect_files_JavaScriptHTML($url);

			//呼び出し元にリダイレクトする
			//It redirects it to the call origin.
			//$url = $return_url . "?config=" . conv_url_code($conf["config"]);
			//$url .= "&returl=" . $conf["returl"];
			$url = $conf["returl"];

			echo get_redirect_url_JavaScriptHTML($url);
			exit;
		}
	}
	if (! $sts) {
		echo $msg;
	}
}
?>

<HR>
<?php

//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>

</CENTER>
</BODY>
</HTML>
