<?php
/******************************************************************************
	Files(WEB file share PHP script)

	Down-loading processing of file

  	download.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2009 Technoworks Co., Ltd. All rights reserved.

	Last Update: 2008/03/25

	Update history:

	Ver.2.5
		ファイルサイズを符号なし32ビット整数で設定するように修正した
		I changed it to treat file size with 32 bits unsigned integer.

	Ver.2.4
		ダウンロード・ファイルのリンク方法を変更した。
		The method of linking the download files was changed. 

		日本語名のファイルをダウンロードする際に、ブラウザの種類を考慮して
		ファイル名を変換するようにした。
		When the file of a Japanese name was downloaded, the file name was 
		converted in consideration of the kind of a browser.

		カットバッファのファイルへのリンク先が間違っていたので修正した
		Because link ahead to the file of the cut buffer was wrong, I revised it

	Ver.2.1		Remove Content-Length
	Ver.2.0		New making

******************************************************************************/

require('session.php');

session_cache_limiter('public');	// for IE6 and IE7

$conf = init_files(FALSE);

$filename = get_post_get_val("filename");
$curdir = get_post_get_val("dir");
//$fullpath = make_path($curdir, "", $filename);
$fullpath = make_path($conf["TOPDIR"], $curdir, $filename);
$user_agent = get_user_agent_type();
$fname = get_filename($filename);

if ($user_agent == "MSIE" || $user_agent == "SAFARI") {
	$fname = conv_url_code($fname);
}

$login_user = get_login_user();

put_log($conf, "Download File=" . $fullpath .
					" curdir=" . $curdir .
					" Size=" . sprintf("%u", filesize($fullpath)) .
					" User=" . $login_user);

$read_size = 64 * 1024;

header('Cache-control: private');
header('Content-Type: application/octet-stream');
header('Content-Length: '. sprintf("%u", filesize($fullpath)));
header('Content-Disposition: filename=' . $fname);

if (($file = fopen($fullpath, "r"))) {
	while (!feof($file)) {
		print fread($file, $read_size);
	}
	fclose($file);
} else {
	die('Error: The file ' . $fullpath . ' can not open!');
}
?>
