<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダ一覧画面
	Shared folder list screen

  	dirlist.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2009 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.1
		configファイルとは別のディレクトリにindex.phpを作成するようにした
		I made index.php in another directory with the config file

		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);
$return_url = get_post_get_val("return_url");

$scriptname = "dirlist.php";

$s_name = files_session_name();
$s_id = session_id();

// 戻り先は共有フォルダ管理メニュー
//The return destination is a common folder management menu.
$conf["returl"] = $conf["CONFMENU_SCRIPT"] . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
//ページヘッダーHTMLを取得
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<?php

$msg = "";

$folder_list = read_folder_list($conf);

if (count($folder_list) <= 0) {
	$msg = get_txt("there is no folder");
}

$newconfurl = $conf["NEWCONF_SCRIPT"];
$newconfurl .= "?config=" . conv_url_code($conf["config"]);
$newconfurl .= "&return_url=" . conv_url_code($conf["SCRIPT_DIR_URL"]);
$newconfurl .= "/" . $scriptname;
$newconfurl .= "&" . $s_name . "=" . $s_id;

?>

<TABLE width=95% border=0>
	<TR>
		<TD>
			<A HREF="<?php echo $newconfurl ?>">
				<B><?php echo get_txt("create shared folder"); ?></B></A>
		</TD>
	</TR>
</TABLE>
<TABLE width=95% border=1>
	<TR BGCOLOR="<?php echo $conf["LIST_HEAD_BG"] ?>">
		<TD align=center>&nbsp;&nbsp;&nbsp;&nbsp;</TD>
		<TD align=center>&nbsp;&nbsp;&nbsp;&nbsp;</TD>
		<TD align=center><B><?php echo get_txt("name"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("url"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("use size"); ?></B></TD>
	</TR>
<?php
	foreach($folder_list as $flist) {
		$conf_file = $flist["CONFIG_FILE"];

		$cfg = read_conf_file($conf_file);

		$modurl = $conf["MODCONF_SCRIPT"];
		$modurl .= "?config=" . conv_url_code($conf["config"]);
		$modurl .= "&config_name=" . conv_url_code($flist["NAME"]);
		$modurl .= "&topdir=" . conv_url_code($cfg["TOPDIR"]);
		$modurl .= "&return_url=" . conv_url_code($conf["SCRIPT_DIR_URL"]);
		$modurl .= "/" . $scriptname;
		$modurl .= "&returl=" . conv_url_code($conf["returl"]);
		$modurl .= "&" . $s_name . "=" . $s_id;

		$delurl = $conf["DELCONF_SCRIPT"];
		$delurl .= "?config=" . conv_url_code($conf["config"]);
		$delurl .= "&config_name=" . conv_url_code($flist["NAME"]);
		$delurl .= "&topdir=" . conv_url_code($cfg["TOPDIR"]);
		$delurl .= "&return_url=" . conv_url_code($conf["SCRIPT_DIR_URL"]);
		$delurl .= "/" . $scriptname;
		$delurl .= "&returl=" . conv_url_code($conf["returl"]);
		$delurl .= "&" . $s_name . "=" . $s_id;

		$url_title = get_entry_page_top_url($conf) .
									"/" . $flist["NAME"] . "/";

		$url = $conf["LOGIN_SCRIPT"];
		$url .= "?config=" . conv_url_code($conf_file);
		$url .= "&return_url=" . conv_url_code($conf["SCRIPT_DIR_URL"]);
		$url .= "/" . $scriptname;
		$url .= "&returl=" . conv_url_code($conf["returl"]);
		$url .= "&" . $s_name . "=" . $s_id;

		$usize = get_dir_use_size($cfg["TOPDIR"]);
		$usize_str = get_filesize_str($usize);

		echo "<TR>\n";

		//更新
		//Update
		echo "<TD align=center><A HREF=\"" . $modurl . "\">" .
								get_txt("update") . "</A></TD>\n";

		//削除
		//Delete
		echo "<TD align=center><A HREF=\"" . $delurl . "\">" .
								get_txt("delete") . "</A></TD>\n";

		//名称
		//Name
		echo "<TD align=left>";
		echo "<A HREF=\"" . $url . "\">" .$flist["NAME"] . "</A>";
		echo "</TD>\n";

		//URL
		echo "<TD align=left>";
		echo "<A HREF=\"" . $url . "\">" . $url_title . "</A>";
		echo "</TD>\n";

		//使用容量
		//Use capacity
		echo "<TD align=right>" . $usize_str . "</TD>\n";

		echo "</TR>\n";
	}
?>

</TABLE>
<HR>
<?php

//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</CENTER>
</BODY>
</HTML>
