<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダ設定メニュー
	Shared folder setting menu

  	confmenu.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2009 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.5
		管理メニューで言語の設定が出来るようにした
		The language was able to be set by the management menu.
	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	共通のページヘッダー部分関数を追加
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$scriptname = "confmenu.php";

$s_name = files_session_name();
$s_id = session_id();

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<!-- Getting Page header HTML -->
<?php echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]); ?>

<CENTER>
<HR>
<TABLE><TR><TD>
<UL>
<?php
	$setlang_url = "setlang.php";
	$setlang_url .= "?config=" . conv_url_code($conf["config"]);
	$setlang_url .= "&return_url=" . $conf["CONFMENU_SCRIPT"];
	$setlang_url .= "&" . $s_name . "=" . $s_id;

	$setconf_url = "setconf.php";
	$setconf_url .= "?config=" . conv_url_code($conf["config"]);
	$setconf_url .= "&return_url=" . $conf["CONFMENU_SCRIPT"];
	$setconf_url .= "&" . $s_name . "=" . $s_id;

	$dirlist_url = $conf["DIRLIST_SCRIPT"];
	$dirlist_url .= "?config=" . conv_url_code($conf["config"]);
	$dirlist_url .= "&return_url=" . $conf["CONFMENU_SCRIPT"];
	$dirlist_url .= "&" . $s_name . "=" . $s_id;

	$newconf_url = $conf["NEWCONF_SCRIPT"];
	$newconf_url .= "?config=" . conv_url_code($conf["config"]);
	$newconf_url .= "&return_url=" . $conf["CONFMENU_SCRIPT"];
	$newconf_url .= "&" . $s_name . "=" . $s_id;

	$login_url = $conf["LOGIN_SCRIPT"] . "?config=" . $conf["config"];
?>

	<LI><A HREF="<?php echo $setlang_url; ?>">
					<?php echo get_txt("select language"); ?></A><br><br>
	<LI><A HREF="<?php echo $setconf_url; ?>">
				<?php echo get_txt("config file placement setting"); ?></A><br><br>
<?php
	//パスワード設定へのリンクを作成する
	//Making The link to the password setting.
	if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "") {
		$pwdurl = $conf["PASSWD_SCRIPT"];
		$pwdurl .= "?config=" . conv_url_code($conf["config"]);
		$pwdurl .= "&return_url=" . $conf["CONFMENU_SCRIPT"];
		$pwdurl .= "&" . $s_name . "=" . $s_id;
		echo "<LI><A HREF=\"" . $pwdurl . "\">" .
					get_txt("password setting") . "</A><br><br>";
	}
?>
	<LI><A HREF="<?php echo $dirlist_url; ?>">
					<?php echo get_txt("shared folder list"); ?></A><br><br>
	<LI><A HREF="<?php echo $newconf_url ?>">
					<?php echo get_txt("create shared folder"); ?></A><br><br>
	<LI><A HREF="<?php echo $login_url ?>">
					<?php echo get_txt("login page"); ?></A><br><br>
</UL>
</TD></TR></TABLE>
<HR>
<?php

//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Making link to the previous page.
echo get_return_url_HTML($conf);

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</CENTER>
</BODY>
</HTML>
