<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	åѤδؿ
	Functions for session.

  	session.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Last Update: 2008/03/25

	Update history:

	Ver.2.4
		ɡեΥˡѹ
		The method of linking the download files was changed. 

		ܸ̾Υեɤݤˡ֥饦μθ
		ե̾Ѵ褦ˤ
		When the file of a Japanese name was downloaded, the file name was 
		converted in consideration of the kind of a browser.

		åȥХåեΥեؤΥ褬ְäƤΤǽ
		Because link ahead to the file of the cut buffer was wrong, I revised it

	Ver.2.3
		PHP 4.3.3 ΥСǡsession_start() ǥ顼ˤʤ礬
		äΤǡsession_start()  ini_set()¹Ԥ褦˽
		It was corrected that ini_set() was executed in the session_start() 
		front because it had become an error by session_start() in the version 
		before PHP 4.3.3 occasionally. 

	Ver.2.2
		Ver.2.1 ǥ꡼ץȤΡʸɤ UTF-8 Υե
		BOMƤΤäΤǡؤ
		The character-code in the script released with Ver.2.1 replaced it because
		there was something that 'BOM' mixes with the file of UTF-8.

	Ver.2.1
		CONFIG_TOP_URL ѻ
		 abolish CONFIG_TOP_URL.

		index.php  config եȤ̤ξ˺褦ˤ
		I made index.php with the config file in another place.

		˥塼˹եɲä
		The configuration file arrangement setting was added to the management
		menu. 

	Ver.2.0
		files_com.php ʬΥ
		It is divided by files_com.php.

******************************************************************************/

//error_reporting(E_ERROR);

$FILES_PROGRAM_NAME = "Files";

$FILES_VERSION_NO = "2.4	";
//$FILES_VERSION_NO = "X.X";

$FILES_COPYRIGHT_STR =  "Copyright (c) 2004-2008" .
			" Technoworks Co., Ltd." .
			" All right reserved";

$MY_HOME_PAGE_URL = "http://www.technoworks.co.jp/";

//$DEBUG_LOG = TRUE;
$DEBUG_LOG = FALSE;

$GLB_CONFIG = array();

function files_session_name()
{
	return "FILES_SESSION";
}

function get_version_no()
{
	return $GLOBALS["FILES_VERSION_NO"];
}

function get_copyright_str()
{
	return $GLOBALS["FILES_COPYRIGHT_STR"];
}

function get_program_name()
{
	return $GLOBALS["FILES_PROGRAM_NAME"];
}

function get_homepage()
{
	return $GLOBALS["MY_HOME_PAGE_URL"];
}

function get_config()
{
	return $GLOBALS["GLB_CONFIG"];
}

function set_config($conf)
{
	$GLOBALS["GLB_CONFIG"] = $conf;
}

function get_env_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_ENV) && isset($_ENV[$val_name])) {
			$val = $_POST[$val_name];
		} elseif (isset($HTTP_ENV_VARS) && isset($HTTP_ENV_VARS[$val_name])) {
			$val = $HTTP_ENV_VARS[$val_name];
		} elseif (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		} elseif (isset($_SERVER) && isset($_SERVER[$val_name])) {
			$val = $_SERVER[$val_name];
		}
	}
	if (get_magic_quotes_gpc()) {
		$val = stripslashes($val);
	}
	return $val;
}

function get_post_get_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_POST) && isset($_POST[$val_name])) {
			$val = $_POST[$val_name];
		} elseif (isset($_GET) && isset($_GET[$val_name])) {
			$val = $_GET[$val_name];
		} elseif (isset($HTTP_POST_VARS) && isset($HTTP_POST_VARS[$val_name])) {
			$val = $HTTP_POST_VARS[$val_name];
		} elseif (isset($HTTP_GET_VARS) && isset($HTTP_GET_VARS[$val_name])) {
			$val = $HTTP_GET_VARS[$val_name];
		} elseif (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		}
	}
	if (get_magic_quotes_gpc()) {
		$val = stripslashes($val);
	}
	$val = htmlspecialchars($val, ENT_QUOTES);

	return $val;
}

function get_session_value($val_name)
{
	if (isset($_SESSION) && isset($_SESSION[$val_name])) {
		return $_SESSION[$val_name];
	}
	if (isset($HTTP_SESSION_VARS) && isset($HTTP_SESSION_VARS[$val_name])) {
		return $HTTP_SESSION_VARS[$val_name];
	}
	return "";
}

function set_session_value($val_name, $value)
{
	if (isset($_SESSION)) {
		$_SESSION[$val_name] = $value;
	} elseif ($HTTP_SESSION_VARS) {
		$HTTP_SESSION_VARS[$val_name] = $value;
	}
}

// եURLܸ줬äƤʸɤʸѴ
//It converts it into the character string of the character-code when
//there is Japanese in file URL. 
function conv_url_code($srcurl)
{
	$ret_url = "";

/*****
	//ޥХʸؿmbstringˤȤ
	//When you can use multi byte character string function (mbstring)
	$len = mb_strlen($srcurl);
	for ($i = 0; $i < $len; $i++) {
		$char = mb_substr($srcurl, $i, 1);
		if (mb_detect_encoding($char) == "ASCII") {
			$ret_url .= $char;
		} else {
			$ret_url .= urlencode($char);
		}
	}
*****/

	$len = strlen($srcurl);
	$i = 0;
	while ($i < $len) {
		$char = substr($srcurl, $i++, 1);
		if (ord($char) <= 0x7f) {
			$ret_url .= $char;
		} else {
			if ($i < $len) {
				$char .= substr($srcurl, $i++, 1);
			}
			$ret_url .= urlencode($char);
		}
	}
/****/
	return $ret_url;
}

//ѥΥե̾ʬΤߤФ
//Only the file name part under passing is taken out. 
function get_filename($dir)
{
	$flds = split("/", $dir);
	$filename = array_pop($flds);

	return $filename;
}

//ե̾Υ١̾ΤߤФ
//Only the base name is taken out of the file name.
function get_basename($path)
{
	$filename = get_filename($path);
	$flds = split("\.", $filename);
	if (isset($flds[0]) && $flds[0] != "") {
		$basename = array_shift($flds);
	} else {
		$basename = $filename;
	}
	return $basename;
}

//ѥΥǥ쥯ȥѥʬΤߤФ
//Only the directory path part under passing is taken out. 
//ʥѥǥ쥯ȥ̾ξϾ̥ǥ쥯ȥΥѥ֤
//(When passing is a directory name, passing a high-ranking directory is returned. )
function get_dirpath($dir)
{
	$flds = split("/", $dir);
	if (count($flds) > 0) {
		$tmp = array_pop($flds);
		$num = count($flds);
		if ($num > 1) {
			$updir = join("/", $flds);
		} elseif ($num > 0) {
			$updir = $flds[0];
		} else {
			$updir = "";
		}
	} else {
		$updir = "";
	}
	return $updir;
}

//եѥȤΩƤ
//The full path is assembled.
function make_path($basedir, $dir, $fname)
{
	$path = $basedir;

	if ($dir != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $dir;
	}
	if ($fname != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $fname;
	}

	return $path;
}

//޶ڤʸΥޤ
//The comma of the comma delimiter is removed. 
function conv_comma_val($comma_val)
{
	$valstr = "";

	$vals = split(",", $comma_val);

	foreach($vals as $val) {
		$valstr .= $val;
	}
	return $valstr;
}

//ͤ3ŤĤΥ޶ڤˤ
//The numerical value is made the comma district switching off of the treble.
function make_comma_val($val)
{
	$tmpstr = "";
	$valstr = "";

	$len = strlen($val);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		if ($i > 0 && $i % 3 == 0) {
			$tmpstr .= ",";
		}
		$tmpstr .= substr($val, $p, 1);
	}
	$len = strlen($tmpstr);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		$valstr .= substr($tmpstr, $p, 1);
	}
	return $valstr;
}

//եɤ߹
//Configuration file reading
function read_conf_file($conffile)
{
	//եǤ
	//Item that can be set by configuration file
	$topdir = getcwd();
	$conf = array(
		"CONFIG_DIR" => 0,
		"CONFIG_TOP_DIR" => "./config",
		"ENTRY_PAGE_DIR_URL" => "",
		"ENTRY_PAGE_TOP_DIR" => "./config",
		"ENTRY_PAGE_TOP_URL" => "./config",
		"SCRIPT_DIR_URL" => "",
		"LISTFILE" => ".files.lst",
		"LOCKFILE" => ".lock_files.lock",
		"LOGFILE" => "./files.log",
		"OUTPUT_LOG" => 0,
		"PASSWD_FILE" => "",
		"GROUP_FILE" => "",
		"DEFAULT_GROUP_FILE" => "group",
		"IMGDIR" => "./images",
		"TOPDIR" => ".",
		"CUTDIR" => "",
		"HEADER_TITLE" => "Files",
		"TITLEIMG" => "",
		"ptitleimg_w" => "200",
		"ptitleimg_h" => "35",
		"TITLESTR" => "Files",
		"TITLE_COMMENT_LOGIN" => "",
		"TITLE_COMMENT_FILES" => "",
		"TITLE_COMMENT_EDIT" => "",
		"TITLE_COMMENT_DELETE" => "",
		"TITLE_COMMENT_MKDIR" => "",
		"TITLE_COMMENT_UPLOAD" => "",
		"LOGIN_TITLE" => "",
		"RETURL1" => "",
		"returntitle1" => "",
		"RETURL2" => "",
		"returntitle2" => "",
		"FILES_SCRIPT" => "files.php",
		"EDIT_SCRIPT" => "edit.php",
		"DELETE_SCRIPT" => "delete.php",
		"COPY_SCRIPT" => "cut.php",
		"CUT_SCRIPT" => "cut.php",
		"PASTE_SCRIPT" => "paste.php",
		"MKDIR_SCRIPT" => "mkdir.php",
		"UPLOAD_SCRIPT" => "upload.php",
		"ATTR_SCRIPT" => "attr.php",
		"LOGIN_SCRIPT" => "login.php",
		"PASSWD_SCRIPT" => "passwd.php",
		"GROUP_SCRIPT" => "group.php",
		"CONFMENU_SCRIPT" => "confmenu.php",
		"NEWCONF_SCRIPT" => "newconf.php",
		"DELCONF_SCRIPT" => "delconf.php",
		"MODCONF_SCRIPT" => "modconf.php",
		"DIRLIST_SCRIPT" => "dirlist.php",
		"UPLOAD_CGI" => "upload.php",
		"DIR_IMAGE" => "folder.png",
		"UP_IMAGE" => "up.png",
		"UP_TITLE" => "to upper folder",
		"EDIT_IMAGE" => "edit.png",
		"DELETE_IMAGE" => "delete.png",
		"COPY_IMAGE" => "copy.png",
		"CUT_IMAGE" => "cut.png",
		"PASTE_IMAGE" => "paste.png",
		"BG_IMAGE" => "",
		"BG_COLOR" => "",
		"ICONSIZE" => "24",
		"ICON_W" => "20",
		"ICON_H" => "24",
		"CALLER_URL" => "",
		"MAX_UPLOAD_SIZE" => 10000000,
		"MAX_TOTAL_SIZE" => 500000000,
		"SORT_KEY" => "time",
		"REVERSE_SORT" => 1,
		"LIST_TITLE_BG" => "#cfccf0",
		"LIST_HEAD_BG" => "#a00ca4",
		"LIST_TITLE_BG2" => "#f0cccf",
		"LIST_HEAD_BG2" => "#a00ca4",
		"ADMIN_USERID" => "",
		"ADMIN_DEFAULT_PASSWD" => "",
		"MD5_PASSWD_USE" => "",
		"DEFAULT_ATTR" => 0777,
		"PERMIT_ALL" => "NO",
		"CONF_DIR_ATTR" => 0775,
		"CONF_FILE_ATTR" => 0664,
		"DATA_DIR_ATTR" => 0775,
		"DATA_FILE_ATTR" => 0664,
		"PWD_FILE_ATTR" => 0660,
		"SHOW_HELP_LINK" => 1,
		"curdir" => "",
		"returl" => "",
		"title" => "",
		"config" => "./files.conf"
	);

	$conf["config"] = $conffile;

	// ե̾̾Ф
	//A set name is taken out of the configuration file name.
	$conf["name"] = get_basename($conffile);

	if (! file_exists($conffile)) {
		echo "config file ($conffile) not exist\n";
		exit;
	}
	if (!($fp = fopen ($conffile, "r"))) {
		echo "config file ($conffile) ca not open\n";
		exit;
	}
	flock($fp, 2);

	while (!feof ($fp)) {
		//ɤ߹
		//One line reading
		$buffer = fgets($fp, 4096);
		$buffer = chop($buffer);

		if (strlen($buffer) < 3) {
			//㣲ܤʤΤǣʸʲιԤϼΤƤ
			//Because they are two items or more, the line of
			//three characters or less is thrown away. 
			continue;
		}
		if (substr($buffer, 0, 1) == "#") {
			//ȹԤϥå
			//The comment line is skipped.
			continue;
		}
		//Ԥԣ¤ʬ
		//The line is divided with TAB.
		$flds = split("\t", $buffer);

		//եɤ뤳
		//There must be a field.
		if (isset($flds[0]) && $flds[0] != "" && isset($flds[1])) {
			switch ($flds[0]) {
			case "CONFIG_DIR":
				//ѥǥ쥯ȥ꤫
				//Is it a directory for the setting?
				$conf["CONFIG_DIR"] = $flds[1];
				break;
			case "CONFIG_TOP_DIR":
				//եǥ쥯ȥδ
				//Base point of configuration file directory
				$conf["CONFIG_TOP_DIR"] = $flds[1];
				break;
			case "ENTRY_PAGE_TOP_DIR":
				//ȥ꡼ڡǼǥ쥯ȥ
				//Entry page files storage directory
				$conf["ENTRY_PAGE_TOP_DIR"] = $flds[1];
				break;
			case "ENTRY_PAGE_TOP_URL":
				//ȥ꡼ڡǼǥ쥯ȥURL
				//URL of entry page files storage directory
				$conf["ENTRY_PAGE_TOP_URL"] = $flds[1];
				break;
			case "LISTFILE":
				//ꥹȥե̾
				//List file name
				$conf["LISTFILE"] = $flds[1];
				break;
			case "LOCKFILE":
				//åե̾
				//Lock file name
				$conf["LOCKFILE"] = $flds[1];
				break;
			case "LOGFILE":
				//ե̾
				//Log file name
				$conf["LOGFILE"] = $flds[1];
				break;
			case "OUTPUT_LOG":
				//Ϥ뤫
				//Is the access log output?
				$conf["OUTPUT_LOG"] = $flds[1];
				break;
			case "PASSWD_FILE":
				//ѥɥե
				//Password file
				$conf["PASSWD_FILE"] = $flds[1];
				break;
			case "GROUP_FILE":
				//롼ץե
				//Group file
				$conf["GROUP_FILE"] = $flds[1];
				break;
			case "DEFAULT_GROUP_FILE":
				$conf["DEFAULT_GROUP_FILE"] = $flds[1];
				break;
			case "IMGDIR":
				//᡼ǥ쥯ȥ
				//Image directory information
				$conf["IMGDIR"] = $flds[1];
				break;
			case "CUTDIR":
				//åȥХåեΥǥ쥯ȥ
				//Directory information on cutting buffer
				$conf["CUTDIR"] = $flds[1];
				break;
			case "TOPDIR":
				//ԣϣХǥ쥯ȥ
				//TOP directory information
				$conf["TOPDIR"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["toptitle"] = $flds[2];
				} else {
					$conf["toptitle"] = "";
				}
				break;
			case "HEADER_TITLE":
				//إåΥȥ
				//Title of header
				$conf["HEADER_TITLE"] = $flds[1];
				break;
			case "TITLEIMG":
				//ȥ륤᡼
				//Title image information
				$conf["TITLEIMG"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["ptitleimg_w"] = $flds[2];
				}
				if (isset($flds[3]) && $flds[3] != "") {
					$conf["ptitleimg_h"] = $flds[3];
				}
				break;
			case "TITLESTR":
				//ȥʸ
				//Title character string information
				$conf["TITLESTR"] = $flds[1];
				break;
			case "TITLE_COMMENT_LOGIN":
				//̤Υȹ
				//Comment line of login screen
				$conf["TITLE_COMMENT_LOGIN"] = $flds[1];
				break;
			case "TITLE_COMMENT_FILES":
				//ե̤Υȹ
				//Comment line of file list screen
				$conf["TITLE_COMMENT_FILES"] = $flds[1];
				break;
			case "TITLE_COMMENT_EDIT":
				//Խ̤Υȹ
				//Comment line of edit display
				$conf["TITLE_COMMENT_EDIT"] = $flds[1];
				break;
			case "TITLE_COMMENT_DELETE":
				//̤Υȹ
				//Comment line of deletion screen
				$conf["TITLE_COMMENT_DELETE"] = $flds[1];
				break;
			case "TITLE_COMMENT_MKDIR":
				//ե̤Υȹ
				//Comment line of folder making screen
				$conf["TITLE_COMMENT_MKDIR"] = $flds[1];
				break;
			case "TITLE_COMMENT_UPLOAD":
				//åץɲ̤Υȹ
				//Comment line of up-loading screen
				$conf["TITLE_COMMENT_UPLOAD"] = $flds[1];
				break;
			case "LOGIN_TITLE":
				//󡦥ȥ
				//Login title
				$conf["LOGIN_TITLE"] = $flds[1];
				break;
			case "RETURL1":
				//URL
				//URL information 1 at return destination
				$conf["RETURL1"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["returntitle1"] = $flds[2];
				} else {
					$conf["returntitle1"] = $flds[1];
				}
				break;
			case "RETURL2":
				//URL
				//URL information 2 at return destination
				$conf["RETURL2"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["returntitle2"] = $flds[2];
				} else {
					$conf["returntitle2"] = $flds[1];
				}
				break;
			case "FILES_SCRIPT":
				//եץ
				//File list script
				$conf["FILES_SCRIPT"] = $flds[1];
				break;
			case "EDIT_SCRIPT":
				//Խץ
				//Edit script
				$conf["EDIT_SCRIPT"] = $flds[1];
				break;
			case "DELETE_SCRIPT":
				//ץ
				//Deletion script
				$conf["DELETE_SCRIPT"] = $flds[1];
				break;
			case "COPY_SCRIPT":
				//ʣ̥ץ
				//Copy script
				$conf["COPY_SCRIPT"] = $flds[1];
				break;
			case "CUT_SCRIPT":
				//ڼꥹץ
				//Cutout script
				$conf["CUT_SCRIPT"] = $flds[1];
				break;
			case "PASTE_SCRIPT":
				//Žդץ
				//Paste script
				$conf["PASTE_SCRIPT"] = $flds[1];
				break;
			case "MKDIR_SCRIPT":
				//եץ
				//Folder making script
				$conf["MKDIR_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_SCRIPT":
				//ե륢åץɥץ
				//File up-loading script
				$conf["UPLOAD_SCRIPT"] = $flds[1];
				break;
			case "ATTR_SCRIPT":
				//ե°ѹץ
				//File attribute change script
				$conf["ATTR_SCRIPT"] = $flds[1];
				break;
			case "LOGIN_SCRIPT":
				//󥹥ץ
				//Login script
				$conf["LOGIN_SCRIPT"] = $flds[1];
				break;
			case "PASSWD_SCRIPT":
				//ѥꥹץ
				//Password setting script
				$conf["PASSWD_SCRIPT"] = $flds[1];
				break;
			case "GROUP_SCRIPT":	//롼ꥹץ
				//롼ꥹץ
				//Group setting script
				$conf["GROUP_SCRIPT"] = $flds[1];
				break;
			case "CONFMENU_SCRIPT":
				//˥塼ץ
				//Set menu script
				$conf["CONFMENU_SCRIPT"] = $flds[1];
				break;
			case "NEWCONF_SCRIPT":
				//ͭեץ
				//Common folder making script
				$conf["NEWCONF_SCRIPT"] = $flds[1];
				break;
			case "DELCONF_SCRIPT":
				//ͭեץ
				//Common folder deletion script
				$conf["DELCONF_SCRIPT"] = $flds[1];
				break;
			case "MODCONF_SCRIPT":
				//ͭե깹ץ
				//Common folder setting update script
				$conf["MODCONF_SCRIPT"] = $flds[1];
				break;
			case "DIRLIST_SCRIPT":
				//ͭեץ
				//Shared folder list script
				$conf["DIRLIST_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_CGI":
				//ե륢åץCGI
				//File up-loading CGI
				$conf["UPLOAD_CGI"] = $flds[1];
				break;
			case "DIR_IMAGE":
				//ե᡼
				//Folder image
				$conf["DIR_IMAGE"] = $flds[1];
				break;
			case "UP_IMAGE":
				//̥ե᡼
				//Upper folder image
				$conf["UP_IMAGE"] = $flds[1];
				break;
			case "UP_TITLE":
				//̥եؤΥȥʸ
				//Title character to upper folder
				$conf["UP_TITLE"] = $flds[1];
				break;
			case "EDIT_IMAGE":
				//Խ᡼
				//Comment edit image
				$conf["EDIT_IMAGE"] = $flds[1];
				break;
			case "DELETE_IMAGE":
				//ե᡼
				//File deletion image
				$conf["DELETE_IMAGE"] = $flds[1];
				break;
			case "COPY_IMAGE":
				//եʣ̥᡼
				//File copy image
				$conf["COPY_IMAGE"] = $flds[1];
				break;
			case "CUT_IMAGE":
				//եڼꥤ᡼
				//File cutout image
				$conf["CUT_IMAGE"] = $flds[1];
				break;
			case "PASTE_IMAGE":
				//եŽդ᡼
				//File paste image
				$conf["PASTE_IMAGE"] = $flds[1];
				break;
			case "BG_IMAGE":
				//طʥ᡼
				//Background image
				$conf["BG_IMAGE"] = $flds[1];
				break;
			case "BG_COLOR":
				//طʿ
				//Background color
				$conf["BG_COLOR"] = $flds[1];
				break;
			case "ICONSIZE":
				//󥵥
				//Size of icon
				$conf["ICONSIZE"] = $flds[1];
				break;
			case "ICON_W":
				//
				//Width of icon
				$conf["ICON_W"] = $flds[1];
				break;
			case "ICON_H":
				//⤵
				//Height of icon
				$conf["ICON_H"] = $flds[1];
				break;
			case "CALLER_URL":
				//ƤӽФգң
				//Call former URL
				$conf["CALLER_URL"] = $flds[1];
				break;
			case "MAX_UPLOAD_SIZE":
				//åץɥեMAX
				//MAX size of up-loading file
				if ($flds[1] != "") {
					$conf["MAX_UPLOAD_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "MAX_TOTAL_SIZE":
				//̤MAX
				//MAX size of use capacity
				if ($flds[1] != "") {
					$conf["MAX_TOTAL_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "SORT_KEY":
				//ǥեȤΥȥ
				//Sorting key to default
				$conf["SORT_KEY"] = $flds[1];
				break;
			case "REVERSE_SORT":
				//Ƚ
				//The order of sorting
				$conf["REVERSE_SORT"] = $flds[1];
				break;
			case "LIST_TITLE_BG":
				//ɽΥȥطʿ
				//Background color of title part of table
				$conf["LIST_TITLE_BG"] = $flds[1];
				break;
			case "LIST_HEAD_BG":
				//ɽΥإåطʿ
				//Background color of header in table
				$conf["LIST_HEAD_BG"] = $flds[1];
				break;
			case "LIST_TITLE_BG2":
				//ɽΥȥطʿ
				//Background color 2 of title part of table
				$conf["LIST_TITLE_BG2"] = $flds[1];
				break;
			case "LIST_HEAD_BG2":
				//ɽΥإåطʿ
				//Background color 2 of header in table
				$conf["LIST_HEAD_BG2"] = $flds[1];
				break;
			case "ADMIN_USERID":
				//ID
				//Manager ID
				$conf["ADMIN_USERID"] = $flds[1];
				break;
			case "ADMIN_DEFAULT_PASSWD":
				//ԤΥǥեȥѥ
				//Manager's default password
				$conf["ADMIN_DEFAULT_PASSWD"] = $flds[1];
				break;
			case "MD5_PASSWD_USE":
				//ѥɤMD5ϥåѤ뤫
				//Is the MD5 hush used for the password?
				$conf["MD5_PASSWD_USE"] = $flds[1];
				break;
			case "DEFAULT_ATTR":
				$conf["DEFAULT_ATTR"] = $flds[1];
				break;
			case "PERMIT_ALL":
				$conf["PERMIT_ALL"] = $flds[1];
				break;
			case "CONF_DIR_ATTR":
				$conf["CONF_DIR_ATTR"] = intval($flds[1], 8);
				break;
			case "CONF_FILE_ATTR":
				$conf["CONF_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "DATA_DIR_ATTR":
				$conf["DATA_DIR_ATTR"] = intval($flds[1], 8);
				break;
			case "DATA_FILE_ATTR":
				$conf["DATA_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "PWD_FILE_ATTR":
				$conf["PWD_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "SHOW_HELP_LINK":
				$conf["SHOW_HELP_LINK"] = $flds[1];
				break;
			}
		}
	}
	flock($fp, 3);
	fclose($fp);

	$conf["SCRIPT_DIR_URL"] = dirname($_SERVER['SCRIPT_NAME']);

	//ȥ꡼ڡΤǥ쥯ȥURL
	//URL of directory with entry page file
	$conf["ENTRY_PAGE_DIR_URL"] = get_entry_page_top_url($conf) . 
											"/" . $conf["name"];

	if ($conf["CUTDIR"] == "" && $conf["TOPDIR"] != "") {
		$conf["CUTDIR"] = $conf["TOPDIR"] . "/.cutbuf";
	}

	return $conf;
}

// ե񤭹
//Configuration file writing
function write_conf_file($conf, $new_conf, $new_conffile)
{
	if (! file_exists($conf["config"])) {
		echo "config file (" . $conf["config"] . ") not exist\n";
		return FALSE;
	}
	$in_fname = realpath($conf["config"]);
	$new_conf_dir = get_dirpath($new_conffile);
	$new_conf_dir = realpath($new_conf_dir);
	$new_conf_fname = get_filename($new_conffile);
	$out_fname = make_path($new_conf_dir, "", $new_conf_fname);

	$tmp_fname = "";
	if (strcasecmp($in_fname, $out_fname) == 0) {
		$tmp_fname = $in_fname . ".tmp";
		if (! rename($in_fname, $tmp_fname)) {
			return FALSE;
		}
		$in_fname = $tmp_fname;
	}
	// ե롦ץ
	//Basic configuration file and opening
	if (!($ifp = fopen ($in_fname, "r"))) {
		echo "config file (" . $conf["config"] , ") can not open\n";
		return FALSE;
	}
	flock($ifp, 2);

	// ե롦ץ
	//Configuration file and opening
	if (!($ofp = fopen ($out_fname, "w"))) {
		echo "new config file (" . $out_fname . ") can not open\n";
		return FALSE;
	}
	flock($ofp, 2);

	while (!feof ($ifp)) {
		//ɤ߹
		//One line reading
		$buffer = fgets($ifp, 4096);
		$buffer = chop($buffer);
		$str = "";
		if (substr($buffer, 0, 1) == "#") {
			//ȹԤϤΤޤ޽
			//The comment line is output as it is.
			$str = $buffer;
		} else if (strlen($buffer) < 3) {
			//㣲ܤʤΤǣʸʲιԤϤΤޤ޽
			//Because they are two items or more, the line of three characters
			//or less is output as it is.
			$str = $buffer;
		} else {
			//Ԥԣ¤ʬ
			//The line is divided with TAB.
			$flds = split("\t", $buffer);

			//եɤ̵ԤϤΤޤ޽
			//The line without the field is output as it is.
			if ($flds[0] == "") {
				$str = $buffer;
			} else {
				switch ($flds[0]) {
				case "CONFIG_DIR":
					$str = $flds[0] . "\t" . $new_conf["CONFIG_DIR"];
					break;
				case "CONFIG_TOP_DIR":
					//եǥ쥯ȥδ
					//Base point of configuration file directory
					$str = $flds[0] . "\t" . $new_conf["CONFIG_TOP_DIR"];
					break;
				case "ENTRY_PAGE_TOP_DIR":
					//ȥ꡼ڡǼǥ쥯ȥ
					//Entry page files storage directory
					$str = $flds[0] . "\t" . $new_conf["ENTRY_PAGE_TOP_DIR"];
					break;
				case "ENTRY_PAGE_TOP_URL":
					//ȥ꡼ڡǼǥ쥯ȥURL
					//URL of entry page files storage directory
					$str = $flds[0] . "\t" . $new_conf["ENTRY_PAGE_TOP_URL"];
					break;
				case "LISTFILE":
					//ꥹȥե̾
					//List file name
					$str = $flds[0] . "\t" . $new_conf["LISTFILE"];
					break;
				case "LOCKFILE":
					//åե̾
					//Lock file name
					$str = $flds[0] . "\t" . $new_conf["LOCKFILE"];
					break;
				case "LOGFILE":
					//ե̾
					//Log file name
					$str = $flds[0] . "\t" . $new_conf["LOGFILE"];
					break;
				case "OUTPUT_LOG":
					//Ϥ뤫
					//Is the access log output?
					$str = $flds[0] . "\t" . $new_conf["OUTPUT_LOG"];
					break;
				case "PASSWD_FILE":
					//ѥɥե
					//Password file
					$str = $flds[0] . "\t" . $new_conf["PASSWD_FILE"];
					break;
				case "GROUP_FILE":
					//Group file
					$str = $flds[0] . "\t" . $new_conf["GROUP_FILE"];
					break;
				case "DEFAULT_GROUP_FILE":
					$str = $flds[0] . "\t" . $new_conf["DEFAULT_GROUP_FILE"];
					break;
				case "IMGDIR":
					//᡼ǥ쥯ȥ
					//Image directory
					$str = $flds[0] . "\t" . $new_conf["IMGDIR"];
					break;
				case "CUTDIR":
					//åȥХåեΥǥ쥯ȥ
					//Directory of cutting buffer
					$str = $flds[0] . "\t" . $new_conf["CUTDIR"];
					break;
				case "TOPDIR":
					//ԣϣХǥ쥯ȥ
					//TOP directory
					$str = $flds[0] . "\t" . $new_conf["TOPDIR"];
					$str .= "\t" . $new_conf["toptitle"];
					break;
				case "HEADER_TITLE":
					//إåΥȥ
					//Title of header
					$str = $flds[0] . "\t" . $new_conf["HEADER_TITLE"];
					break;
				case "TITLEIMG":
					//ȥ륤᡼
					//Title image
					$str = $flds[0] . "\t" . $new_conf["TITLEIMG"];
					$str .= "\t" . $new_conf["ptitleimg_w"];
					$str .= "\t" . $new_conf["ptitleimg_h"];
					break;
				case "TITLESTR":
					//ȥʸ
					//Title string
					$str = $flds[0] . "\t" . $new_conf["TITLESTR"];
					break;
				case "TITLE_COMMENT_LOGIN":
					//̤Υȹ
					//Comment line of login screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_LOGIN"];
					break;
				case "TITLE_COMMENT_FILES":
					//ե̤Υȹ
					//Comment line of file list screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_FILES"];
					break;
				case "TITLE_COMMENT_EDIT":
					//Խ̤Υȹ
					//Comment line of edit display
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_EDIT"];
					break;
				case "TITLE_COMMENT_DELETE":
					//̤Υȹ
					//Comment line of deletion screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_DELETE"];
					break;
				case "TITLE_COMMENT_MKDIR":
					//ե̤Υȹ
					//Comment line of folder making screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_MKDIR"];
					break;
				case "TITLE_COMMENT_UPLOAD":
					//åץɲ̤Υȹ
					//Comment line of up-loading screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_UPLOAD"];
					break;
				case "LOGIN_TITLE":
					//󡦥ȥ
					//Login title
					$str = $flds[0] . "\t" . $new_conf["LOGIN_TITLE"];
					break;
				case "RETURL1":
					//URL
					//URL at return-1 destination
					$str = $flds[0] . "\t" . $new_conf["RETURL1"];
					$str .= "\t" . $new_conf["returntitle1"];
					break;
				case "RETURL2":
					//URL
					//URL at return-2 destination
					$str = $flds[0] . "\t" . $new_conf["RETURL2"];
					$str .= "\t" . $new_conf["returntitle2"];
					break;
				case "FILES_SCRIPT":
					//եץ
					//File list script
					$str = $flds[0] . "\t" . $new_conf["FILES_SCRIPT"];
					break;
				case "EDIT_SCRIPT":
					//Խץ
					//Edit script
					$str = $flds[0] . "\t" . $new_conf["EDIT_SCRIPT"];
					break;
				case "DELETE_SCRIPT":
					//ץ
					//Delete script
					$str = $flds[0] . "\t" . $new_conf["DELETE_SCRIPT"];
					break;
				case "COPY_SCRIPT":
					//ʣ̥ץ
					//Copy script
					$str = $flds[0] . "\t" . $new_conf["COPY_SCRIPT"];
					break;
				case "CUT_SCRIPT":
					//ڼꥹץ
					//Cut script
					$str = $flds[0] . "\t" . $new_conf["CUT_SCRIPT"];
					break;
				case "PASTE_SCRIPT":
					//Žդץ
					//Paste script
					$str = $flds[0] . "\t" . $new_conf["PASTE_SCRIPT"];
					break;
				case "MKDIR_SCRIPT":
					//եץ
					//Folder making script
					$str = $flds[0] . "\t" . $new_conf["MKDIR_SCRIPT"];
					break;
				case "UPLOAD_SCRIPT":
					//ե륢åץɥץ
					//File up-loading script
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_SCRIPT"];
					break;
				case "ATTR_SCRIPT":
					//ե°ѹץ
					//File attribute change script
					$str = $flds[0] . "\t" . $new_conf["ATTR_SCRIPT"];
					break;
				case "LOGIN_SCRIPT":
					//󥹥ץ
					//Login script
					$str = $flds[0] . "\t" . $new_conf["LOGIN_SCRIPT"];
					break;
				case "PASSWD_SCRIPT":
					//ѥꥹץ
					//Password setting script
					$str = $flds[0] . "\t" . $new_conf["PASSWD_SCRIPT"];
					break;
				case "GROUP_SCRIPT":
					//롼ꥹץ
					//Group setting script
					$str = $flds[0] . "\t" . $new_conf["GROUP_SCRIPT"];
					break;
				case "CONFMENU_SCRIPT":
					//˥塼ץ
					//Set menu script
					$str = $flds[0] . "\t" . $new_conf["CONFMENU_SCRIPT"];
					break;
				case "NEWCONF_SCRIPT":
					//ͭեץ
					//Shared folder making script
					$str = $flds[0] . "\t" . $new_conf["NEWCONF_SCRIPT"];
					break;
				case "DELCONF_SCRIPT":
					//ͭեץ
					//Shared folder deletion script
					$str = $flds[0] . "\t" . $new_conf["DELCONF_SCRIPT"];
					break;
				case "MODCONF_SCRIPT":
					//ͭե깹ץ
					//Shared folder setting update script
					$str = $flds[0] . "\t" . $new_conf["MODCONF_SCRIPT"];
					break;
				case "DIRLIST_SCRIPT":
					//ͭեץ
					//Shared folder list script
					$str = $flds[0] . "\t" . $new_conf["DIRLIST_SCRIPT"];
					break;
				case "UPLOAD_CGI":
					//ե륢åץCGI
					//File up-loading CGI
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_CGI"];
					break;
				case "DIR_IMAGE":
					//ե᡼
					//Folder image
					$str = $flds[0] . "\t" . $new_conf["DIR_IMAGE"];
					break;
				case "UP_IMAGE":
					//̥ե᡼
					//Upper folder image
					$str = $flds[0] . "\t" . $new_conf["UP_IMAGE"];
					break;
				case "UP_TITLE":
					//̥եؤΥȥʸ
					//Title character to upper folder
					$str = $flds[0] . "\t" . $new_conf["UP_TITLE"];
					break;
				case "EDIT_IMAGE":
					//Խ᡼
					//Edit image
					$str = $flds[0] . "\t" . $new_conf["EDIT_IMAGE"];
					break;
				case "DELETE_IMAGE":
					//ե᡼
					//File deletion image
					$str = $flds[0] . "\t" . $new_conf["DELETE_IMAGE"];
					break;
				case "COPY_IMAGE":
					//եʣ̥᡼
					//File copy image
					$str = $flds[0] . "\t" . $new_conf["COPY_IMAGE"];
					break;
				case "CUT_IMAGE":
					//եڼꥤ᡼
					//File cutout image
					$str = $flds[0] . "\t" . $new_conf["CUT_IMAGE"];
					break;
				case "PASTE_IMAGE":
					//եŽդ᡼
					//File paste image
					$str = $flds[0] . "\t" . $new_conf["PASTE_IMAGE"];
					break;
				case "BG_IMAGE":
					//طʥ᡼
					//Background image
					$str = $flds[0] . "\t" . $new_conf["BG_IMAGE"];
					break;
				case "BG_COLOR":
					//طʿ
					//Background color
					$str = $flds[0] . "\t" . $new_conf["BG_COLOR"];
					break;
				case "ICONSIZE":
					//󥵥
					//Size of icon
					$str = $flds[0] . "\t" . $new_conf["ICONSIZE"];
					break;
				case "ICON_W":
					//󥵥
					//Width of size of icon
					$str = $flds[0] . "\t" . $new_conf["ICON_W"];
					break;
				case "ICON_H":
					//󥵥⤵
					//Height of size of icon
					$str = $flds[0] . "\t" . $new_conf["ICON_H"];
					break;
				case "CALLER_URL":
					//ƤӽФգң
					//Call former URL
					$str = $flds[0] . "\t" . $new_conf["CALLER_URL"];
					break;
				case "MAX_UPLOAD_SIZE":
					//åץɥեMAX
					//MAX size of up-loading file
					$str = $flds[0] . "\t" . $new_conf["MAX_UPLOAD_SIZE"];
					break;
				case "MAX_TOTAL_SIZE":
					//̤MAX
					//MAX size of use capacity
					$str = $flds[0] . "\t" . $new_conf["MAX_TOTAL_SIZE"];
					break;
				case "SORT_KEY":
					//ǥեȤΥȥ
					//Sorting key to default
					$str = $flds[0] . "\t" . $new_conf["SORT_KEY"];
					break;
				case "REVERSE_SORT":
					//Ƚ
					//The order of sorting
					$str = $flds[0] . "\t" . $new_conf["REVERSE_SORT"];
					break;
				case "LIST_TITLE_BG":
					//ɽΥȥطʿ
					//Background color of title part of table
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG"];
					break;
				case "LIST_HEAD_BG":
					//ɽΥإåطʿ
					//Background color of header in table
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG"];
					break;
				case "LIST_TITLE_BG2":
					//ɽΥȥطʿ
					//Background color 2 of title part of table
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG2"];
					break;
				case "LIST_HEAD_BG2":
					//ɽΥإåطʿ
					//Background color 2 of header in table
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG2"];
					break;
				case "ADMIN_USERID":
					//ID
					//Manager ID
					$str = $flds[0] . "\t" . $new_conf["ADMIN_USERID"];
					break;
				case "ADMIN_DEFAULT_PASSWD":
					//ԤΥǥեȥѥ
					//Manager's default password
					$str = $flds[0] . "\t" . $new_conf["ADMIN_DEFAULT_PASSWD"];
					break;
				case "MD5_PASSWD_USE":
					//ѥɤMD5ϥåѤ뤫
					//Is the MD5 hush used for the password?
					$str = $flds[0] . "\t" . $new_conf["MD5_PASSWD_USE"];
					break;
				case "DEFAULT_ATTR":
					//ǥեȤΥѡߥå
					//Permission of default
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DEFAULT_ATTR"]);
					break;
				case "PERMIT_ALL":
					$str = $flds[0] . "\t" . $new_conf["PERMIT_ALL"];
					break;
				case "CONF_DIR_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["CONF_DIR_ATTR"]);
					break;
				case "CONF_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["CONF_FILE_ATTR"]);
					break;
				case "DATA_DIR_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DATA_DIR_ATTR"]);
					break;
				case "DATA_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DATA_FILE_ATTR"]);
					break;
				case "PWD_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["PWD_FILE_ATTR"]);
					break;
				case "SHOW_HELP_LINK":
					$str = $flds[0] . "\t" . $new_conf["SHOW_HELP_LINK"];
					break;
				case "toptitle":
				case "ptitleimg_h":
				case "ptitleimg_w":
				case "returntitle1":
				case "returntitle2":
				case "curdir":
				case "returl":
				case "title":
				case "config":
					continue;
					break;
				default:
					$str = $buffer;
					break;
				}
			}
		}
		fputs($ofp, "$str\n");
	}
	flock($ifp, 3);
	fclose($ifp);

	flock($ofp, 3);
	fclose($ofp);

	chmod($out_fname, get_conf_file_attr($conf));

	if ($tmp_fname != "") {
		unlink($tmp_fname);
	}

	return TRUE;
}

//ȥ꡼ڡǼǥ쥯ȥ
//Getting entry page files storage directory
function get_entry_page_top_dir($conf)
{
	$entry_page_top_dir = $conf["ENTRY_PAGE_TOP_DIR"];
	return $entry_page_top_dir;
}

//ȥ꡼ڡǼǥ쥯ȥURL
//Getting URL of entry page files storage directory
function get_entry_page_top_url($conf)
{
	$entry_page_top_url = $conf["ENTRY_PAGE_TOP_URL"];
	return $entry_page_top_url;
}

// ͭեγǼѥǥ쥯ȥ
//Directory acquisition for storage of shared folder setting
function get_conf_top_dir($conf)
{
	$conftop = $conf["CONFIG_TOP_DIR"];
	return $conftop;
}

//ѤΥեΥѡߥå
function get_conf_dir_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["CONF_DIR_ATTR"];
}

//ѤΥեΥѡߥå
function get_conf_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["CONF_FILE_ATTR"];
}

//ǡѥեΥѡߥå
function get_data_dir_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["DATA_DIR_ATTR"];
}

//ǡեΥѡߥå
function get_data_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0666;
	}
	return $conf["DATA_FILE_ATTR"];
}

//ѥɥեΥѡߥå
function get_pwd_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0666;
	}
	return $conf["PWD_FILE_ATTR"];
}

//BODYطʿطʥ᡼ʸ
//Acquisition of set string of background color/background image of BODY
function get_body_bg_str($conf)
{
	$bg_str = "";

	if ($conf["BG_COLOR"] != "") {
		$bg_str .= " bgColor=" . $conf["BG_COLOR"];
	}
	if ($conf["BG_IMAGE"] != "") {
		$bg_str .= " background=";
		if ($conf["IMGDIR"] != "") {
			$bg_str .= $conf["IMGDIR"] . "/";
		}
		$bg_str .= $conf["BG_IMAGE"];
	}
	return $bg_str;
}

//ƤӽФURLΥå
//Call former URL check
function referer_url_check($conf, $referer_url, $block_flg, $default)
{
	if (isset($default)) {
		$acess_flg = $default;
	} else {
		$acess_flg = TRUE;
	}

	if ($conf["CALLER_URL"] != "") {
		if (stristr($referer_url, $conf["SCRIPT_DIR_URL"])) {
			$acess_flg = TRUE;
		} else {
			if (!isset($referer_url) || $referer_url == "") {
				$acess_flg = FALSE;
			} else {
				$acess_flg = FALSE;
				$ref_url_list = split(",", $conf["CALLER_URL"]);
				foreach($ref_url_list as $ref_url) {
					if (stristr($referer_url, $ref_url)) {
						$acess_flg = TRUE;
						break;
					}
				}
			}
		}
	}
	if ($acess_flg == FALSE && $block_flg == TRUE) {
		$bgstr = get_body_bg_str($conf);
		echo "<HTML><HEAD>\n";
		echo "<TITLE>" . $conf["title"] . "</TITLE></HEAD>";
		echo "<BODY " . $bgstr . ">";
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo "could not access" . "<BR>\n";
		echo "please confirm permission" . "<BR><BR></B>\n";
		echo "<A HREF=\"" . $referer_url . "\">" . $referer_url . "</A>\n";
		echo "</BODY></HTML>\n";
		exit;
	}
	return $acess_flg;
}

function get_login_user()
{
	return get_session_value("LOGIN_USER");
}

//󡦥å
//Login check
function login_check($conf)
{
	//ѥɥեȥ󥹥ץȤåȤƤ뤫
	//Are the password file and the login script set?
	if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "" &&
			isset($conf["LOGIN_SCRIPT"]) && $conf["LOGIN_SCRIPT"] != "") {
		//åѿå
		//The session variable is checked.
		$login_user = get_login_user();
		if (!(isset($login_user) && $login_user != "")) {
			//åѿåȤƤʤ
			//The session variable is not set.
			return FALSE;
		}
	}
	return TRUE;
}

// JavaScriptȤäƥ̤˥쥯ȤHTMLʸ
//HTML redirected to the login screen by using JavaScript is acquired.
function get_redirect_login_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["LOGIN_SCRIPT"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

function put_log($conf, $msg)
{
	if ($conf["OUTPUT_LOG"] != 1) {
		return TRUE;
	}
	$remote_addr = get_env_val("REMOTE_ADDR");

	$user = get_login_user();

	$access = date("Y/m/d H:i:s");
	$logmsg = "$access $remote_addr $user $msg\n";

	// ե񤭹ߥץ
	//Log file writing opening
	if (($fp = fopen ($conf["LOGFILE"], "a"))) {
		flock($fp, 2);

   		// Ͽ
		//The log is recorded.
		fputs($fp, $logmsg);

		flock($fp, 3);
		fclose($fp);

		return TRUE;
	}
	return FALSE;
}

function put_dbg_log($conf, $msg)
{
	if ($GLOBALS["DEBUG_LOG"]) {
		return put_log($conf, $msg);
	}
	return TRUE;
}

function put_info_log($conf, $msg)
{
	$remote_addr = get_env_val("REMOTE_ADDR");

	$user = get_login_user();

	openlog("files", LOG_PID | LOG_PERROR, LOG_LOCAL0);

    // Ͽ
	//The log is recorded.
    $access = date("Y/m/d H:i:s");
    syslog(LOG_INFO, "$access $remote_addr $user $msg");

	closelog();
}

function get_user_agent_type()
{
	$user_agent = get_env_val("HTTP_USER_AGENT");

	$browser_type = "ANY";

	if (isset($user_agent) && $user_agent != "") {
		if (stristr($user_agent, "MSIE")) {
			$browser_type = "MSIE";
		} elseif (stristr($user_agent, "Firefox")) {
			$browser_type = "FIREFOX";
		} elseif (stristr($user_agent, "Opera")) {
			$browser_type = "OPERA";
		} elseif (stristr($user_agent, "Safari")) {
			$browser_type = "SAFARI";
		}
	}
	return $browser_type;
}

function init_files($login_page)
{
	if (version_compare(phpversion(), "4.4.0") < 0) {
		ini_set("session.save_handler", "files");
	}
	session_name(files_session_name());
	session_start();

	$http_referer = get_env_val("HTTP_REFERER");
	$remote_user = get_env_val("REMOTE_USER");

	$returl = get_post_get_val("returl");
	$config = get_post_get_val("config");
	$dir = get_post_get_val("dir");

	$conffile = "./files.conf";
	if (isset($config) && $config != "") {
		$conffile = $config;
	}
	$topdir = getcwd();

	if (isset($remote_user)) {
		$user = $remote_user;
	}

	// եɤ߹
	//Configuration file reading
	$conf = read_conf_file($conffile);

	if (isset($config) && $config != "") {
		$conf["config"] = get_filename($config);
	}
	if (isset($returl) && $returl != "") {
		$conf["returl"] = $returl;
	}
	if (isset($conf["TOPDIR"])) {
		$topdir = $conf["TOPDIR"];
	}
	if (!isset($conf["CUTDIR"]) || $conf["CUTDIR"] == "") {
		$conf["CUTDIR"] = $conf["TOPDIR"] . "/" . ".cutdir";
	}

	//եѥ
	//The full path is obtained.
	$topdir = realpath($topdir);

	$conf["config"] = $conffile;
	if (isset($dir)) {
		$conf["curdir"] = $dir;
	} else {
		$conf["curdir"] = "";
	}
	// ȥǥ쥯ȥ̾ե̾Ф
	//The file name is taken out of the current directory name.
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");
	$conf["title"] = get_filename($curdir);
	$conf["uptime"] = date("Y/m/d H:i:s", filemtime($curdir));

	$conf_path = realpath($conf["config"]);
	$save_conf_path = get_session_value("CONFIG_FNAME");

	$allow_user ="";

	//åΩե뤬äƤʤå
	//It checks whether neither the session establishment nor the 
	//configuration file are different.
	if ($save_conf_path != $conf_path) {
		$change_config = get_session_value("CHANGE_CONFIG_FILE");
		if (isset($change_config) &&
					strcmp("TRUE", $change_config) == 0) {
			$allow_user = get_session_value("ALLOW_USER");
		} else {
			set_session_value("ALLOW_USER", "");
			set_session_value("LOGIN_USER", "");
		}
	} else {
		$allow_user = get_session_value("ALLOW_USER");
	}

	set_session_value("CONFIG_FNAME", $conf_path);
	$session = FALSE;
	if (isset($allow_user)) {
		if (strncmp("123", $allow_user, 3) == 0) {
			$session = TRUE;
		}
	}
	if (! $session) {
		//åѿåȤƤʤʥ̤
		//The session variable is not set. (Not logged it in yet. )
		$return_url = "";
		if ($returl != "") {
			$return_url = $returl;
		}
		if ($return_url != "") {
			set_session_value("RETURN_URL", $return_url);
		}
		//ƤӽФURLΥå
		//Call former URL check
		if (!(isset($conf["CALLER_URL"]) && $conf["CALLER_URL"] != "" &&
				referer_url_check($conf, $http_referer, FALSE, TRUE))) {
			//̵˵ĤƤ륵ȤθƤӽФǤϤʤ
			//It is not a call from the site that has been 
			//unconditionally permitted.
			if (!login_check($conf)) {
				//̤󤷤Ƥʤ
				//It has not logged it in yet.
				if ($login_page != TRUE) {
					//ڡǤʤʤڡ˥
					//It jumps to the login page if it is not a login page.
					echo get_redirect_login_JavaScriptHTML($conf);
					exit;
				}
				//Хѿ˥åȤ
				set_config($conf);

				return $conf;
			}
		}
		set_session_value("ALLOW_USER", "123");
	}
	$conf["returl"] = get_session_value("RETURN_URL");

	//Хѿ˥åȤ
	set_config($conf);

	return $conf;
}
?>