#!/usr/bin/php
<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	ե롿եΥڡȽ
	Paste processing of file/folder

  	paste.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.1
		եɲ
		The configuration file arrangement setting is added.

	Ver.2.0
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 ޤǤι
	Update history to Ver.1.4
		2005/08/02	ڡإåʬ̲
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$fuser = get_post_get_val("user");
$fgroup = get_post_get_val("group");
$fattr = get_post_get_val("attr");

$scriptname = "paste.php";

$msg = "";
$sts = FALSE;

//Žդ
//Paste processing
if ($fname != "") {

	//桼
	//Login user
	$login_user = get_login_user();

	//桼ν°롼
	//Login user's belonging group
	$login_user_groups = get_user_groups($conf, $login_user);

	//ȥǥ쥯ȥΥѥ
	//Passing the current directory is acquired.
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");
	$path = make_path($conf["CUTDIR"], "", $fname);
	$dstpath = make_path($curdir, "", $fname);

	//ȥǥ쥯ȥξ
	//Information on the current directory is obtained.
	$curdir_inf = get_file_info($conf, $curdir);

	//ȥǥ쥯ȥΥѡߥå
	//The permission of the current directory is obtained.
	$curdir_permit = get_permission($conf, $curdir_inf,
									$login_user, $login_user_groups);

	$folder_flg = is_dir($path);
	if ($folder_flg) {
		$type_str = get_txt("folder");
	} else {
		$type_str = get_txt("file");
	}

	$sts = FALSE;
	if (!$curdir_permit["w"]) {
		$msg .= get_txt("writing has not been permitted");
		put_log($conf, "Paste failure : " . get_txt("writing has not been permitted"));
	} elseif (file_exists($dstpath)) {
		$msg .= get_txt("destination name overlaps") .
							"&nbsp(" . $type_str . ")<br>\n";
		put_log($conf, "Paste failure : filename already exist : " . $dstpath);
	} else {
		// ե̾ѹ
		//Change in file name
		$sts = rename($path, $dstpath);
		if (!$sts) {
			$msg .= get_txt("cannot paste") .
								"&nbsp(" . $type_str . ")<br>\n";
			put_log($conf, "Paste failure : " . $msg);
		} else {
			put_log($conf, "Paste File=" . $dstpath . " User=" . $login_user);
		}
	}
	if ($sts) {
		//ȥǥ쥯ȥå
		//The current directory is locked.
		$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
		$lock_fp = lock_files($lockfile);
		if (! $lock_fp) {
			$msg .= get_txt("cannot lock current folder") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Paste failure : can not lock folder : " . $curdir);
		} else {
			//åȥХåեå
			//The cutting buffer is locked.
			$cutlockfile = make_path($conf["CUTDIR"], "", $conf["LOCKFILE"]);
			$cutlock_fp = lock_files($cutlockfile);
			if (! $cutlock_fp) {
				//å
				//The lock is released.
				unlock_files($lock_fp, $lockfile);
				echo get_txt("cannot lock cut buffer") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Paste failure : can not lock cut buffer");
			}
		}
		if ($sts) {
			//ȥǥ쥯ȥΥեꥹȤ򹹿
			//The file list of the current directory is updated.

			// եꥹȤɤ߹
			//The file list is read.
			$listfile = make_path($curdir, "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($curdir, $conf["LISTFILE"]);
			}
			//ȥǥ쥯ȥΥե
			//The file list in the current directory is obtained.
			list($files, $update) = get_dirfiles($conf, $curdir, $list_files);

			for ($i = 0; $i < count($files); $i++) {
				$finf = $files[$i];
				if ($finf["name"] == $fname) {
					$finf["name"] = $fname;
					$finf["comment"] = $comment;
					$finf["owner"] = $owner;
					$finf["date"] = $date;
					$finf["time"] = $time;
					$finf["user"] = $fuser;
					$finf["group"] = $fgroup;
					$finf["attr"] = $fattr;
					$files[$i] = $finf;
					break;
				}
			}
			put_log($conf, "Paste success : " . $dstpath);

			// ȥǥ쥯ȥΥեꥹȽ񤭹
			//File list of current directory writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write file list") . 
								"&nbsp;(" . $listfile . ")<br>\n";
			}
			//ȥǥ쥯ȥΥå
			//The lock of the current directory is released.
			unlock_files($lock_fp, $lockfile);

			//åȥХåեΥեꥹȤ򹹿
			//The file list of the cutting buffer is updated.

			// åȥХåեΥեꥹȤɤ߹
			//The file list of the cutting buffer is read.
			$listfile = make_path($conf["CUTDIR"], "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($conf["CUTDIR"], $conf["LISTFILE"]);
			}
			//åȥХåեΥե
			//The file list in the cutting buffer is obtained.
			list($files, $update) = get_dirfiles($conf,
											$conf["CUTDIR"], $list_files);

			// åȥХåեΥեꥹȽ񤭹
			//File list of cutting buffer writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write cut buffer file list") .
								"&nbsp;(" . $listfile . ")<br>\n";
			}
			//åȥХåեΥå
			//The lock of the cutting buffer is released.
			unlock_files($cutlock_fp, $cutlockfile);

			//եդ򹹿
			update_dir_time($conf, $curdir, "", "");
		}
	}
} else {
	$msg .= get_txt("file name is not specified") . "<br>\n";
	put_log($conf, "Paste failure : no file name");
}

if ($sts) {
	//ե˥쥯Ȥ
	//It redirects it to the file list.
	echo get_redirect_files_JavaScriptHTML($conf);
	exit;
}

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>
<?php
if (!$sts) {
	echo $msg;
	echo "<HR>";
	//եHTMLʸ
	//The HTML string to return to the file list is acquired.
	echo get_return_files_HTML($conf);
}

//ڡեåʥץࡦСCopyrightɽ
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>

</BODY>
</HTML>
