#!/usr/bin/php
<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	ե롿եκ
	Deletion processing of file/folder

	delete.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.1
		եɲ
		The configuration file arrangement setting is added.

	Ver.2,0	
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 ޤǤι
	Update history to Ver.1.4
		2005/08/02	ڡإåʬ̲
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$mode = get_post_get_val("mode");

$CUTMODE = get_post_get_val("CUTMODE");

$submit = get_post_get_val("submit");
$cancel = get_post_get_val("cancel");

$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$user = get_post_get_val("user");
$group = get_post_get_val("group");
$attr = get_post_get_val("attr");

$scriptname = "delete.php";

$s_name = files_session_name();
$s_id = session_id();

//桼
//Login user
$login_user = get_login_user();

//桼ν°롼
//Login user's belonging group
$login_user_groups = get_user_groups($conf, $login_user);

//ȥǥ쥯ȥΥѥ
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

if ($CUTMODE == "1") {
	$curdir = $conf["CUTDIR"];
}

$type_str = get_txt("file");
$folder_flg = FALSE;
if ($fname != "") {
	$file_path = make_path($curdir, "", $fname);
	$folder_flg = is_dir($file_path);
	if ($folder_flg) {
		$type_str = get_txt("folder");
	}
}

//ȥǥ쥯ȥξ
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//ȥǥ쥯ȥΥѡߥå
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);

$path = make_path($curdir, "", $fname);

//եξ
//Information on the targeted file is obtained.
$finf = get_file_info($conf, $path);

$permit = get_permission($conf, $finf,
							$login_user, $login_user_groups);

if ($mode != "send") {
	//ǧեɽ
	//Deletion confirmation form display

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
	//ڡإåHTML
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "TITLE_COMMENT_DELETE",
									TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<TABLE width=95% border=0><TBODY>
	<TR>
		<TD>
			<?php
				//HTMLʸ
				//The HTML string to return to the file list is acquired.
				echo get_return_files_HTML($conf); 
			?>
		</TD>
	</TR>
	<TR>
		<TD>
			<P align=center><B><?php echo $conf["title"]; ?></B>&nbsp;&nbsp;
				(<?php echo get_txt("update datetime") . " : " . $conf["uptime"]; ?>)
			</P>
		</TD>
	</TR>
</TBODY></TABLE>
<?php
	if ((($curdir_permit["w"] && $permit["w"]) &&
					!($folder_flg && !$permit["x"])) || $CUTMODE) {
?>
<form action="<?php echo $conf["DELETE_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="dir" value="<?php echo $conf["curdir"] ?>">
	<input type="hidden" name="CUTMODE" value="<?php echo $CUTMODE ?>">
	<input type="hidden" name="fname" value="<?php echo $fname ?>">
	<input type="hidden" name="comment" value="<?php echo $comment ?>">
	<input type="hidden" name="owner" value="<?php echo $owner ?>">
	<input type="hidden" name="date" value="<?php echo $date ?>">
	<input type="hidden" name="time" value="<?php echo $time ?>">
	<input type="hidden" name="user" value="<?php echo $user ?>">
	<input type="hidden" name="group" value="<?php echo $group ?>">
	<input type="hidden" name="attr" value="<?php echo $attr ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER>
					<B><?php echo $type_str . ":" . get_txt("is delete ok"); ?></B>
				</CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo $type_str . get_txt("name"); ?>:</B></TD>
			<TD><?php echo $fname ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("comment"); ?>:</B></TD>
			<TD><?php echo noblank_str($comment) ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create user name"); ?>:</B></TD>
			<TD><?php echo noblank_str($owner) ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create date"); ?>:</B></TD>
			<TD><?php echo $date ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create time"); ?>:</B></TD>
			<TD><?php echo $time ?></TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" value="<?php echo get_txt("delete"); ?>">
				</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>
<?php
	} else {	//($curdir_permit["w"] && $permit["w"])
		echo "<b>";
		echo get_txt("writing has not been permitted");
		echo "</b>";
	}
?>
<HR>
<?php
	//裱裲ؤΥ󥯤ɽHTML
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);
?>

<?php

} else {
	//
	//Deletion processing

	// Ȥꤢ顼ΥåѰդ
	//The message of the error is prepared for the time being.
	$msg = "";
	$sts = FALSE;

	if ((($curdir_permit["w"] != 1) || ($permit["w"] != 1) ||
					($folder_flg && $permit["x"] != 1)) && !$CUTMODE) {
		//echo "writing has not been permitted\n";
		$msg = get_txt("writing has not been permitted");
	} elseif ($fname != "") {
		$path = make_path($curdir, "", $fname);
		if ($folder_flg) {
			$res = check_delete_permit($conf, $path, $login_user, $login_user_groups);
			if (!$CUTMODE && ! $res) {
				$msg = get_txt("writing has not been permitted");
			} else {
				if ($CUTMODE) {
					$sts = delete_dir($path);
				} else {
					$sts = delete_dir_with_permit($conf, $path,
								$login_user, $login_user_groups);
				}
				if (!$sts) {
					$msg = "delete_dir_with_permit():" .
								get_txt("cannot delete") . "<br>\n";
				} else {
					put_log($conf, "Delete Folder=" . $path .
											" User=" . $login_user);
				}
			}
		} else {
			$sts = unlink($path);
			if ($sts) {
				put_log($conf, "Delete File=" . $path .
										" User=" . $login_user);
			}
		}
		if ($sts) {
			//å
			//It locks.
			$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
			$lock_fp = lock_files($lockfile);
			if (! $lock_fp) {
				$msg .= get_txt("annot lock") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete failure : can not lock");
			} else {
				// եꥹȵϿե̾
				//File list record file name
				$listfile = make_path($curdir, "", $conf["LISTFILE"]);

				// եꥹȤɤ߹
				//The file list is read.
				if (file_exists($listfile)) {
					$list_files = read_filelist($curdir, $conf["LISTFILE"]);
				}

				//ȥǥ쥯ȥΥե
				//The file list in the current directory is obtained.
				list($files, $update) = get_dirfiles($conf,
													$curdir, $list_files);

				// եꥹȽ񤭹
				//File list writing
				if (!write_file_list($listfile, $files)) {
					$msg .= get_txt("cannot write file list") .
											":" . $listfile . "<br>\n";
					$sts = FALSE;
					put_log($conf, "Delete failure : " . $path .
											" : can not update file list");
				}
				//å
				//The lock is released.
				unlock_files($lock_fp, $lockfile);

				if ($sts) {
					put_log($conf, "Delete success : " . $path);

					//եդ򹹿
					update_dir_time($conf, $curdir, "", "");
				}
			}
		} else {
			$msg .= $type_str . "(" . $fname . "):" .
								get_txt("cannot delete") . "<br>\n";
			put_log($conf, "Delete failure : can not delete " . $path);
		}
	} else {
		put_log($conf, "Delete failure : no file name");
		$msg .= get_txt("file name is not specified") . "<br>\n";
	}

	if ($sts) {
		//ե˥쥯Ȥ
		//It redirects it to the file list.
		echo get_redirect_files_JavaScriptHTML($conf);
		exit;
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>

<?php
	if (!$sts) {
		echo $msg;
		echo "<HR>";
		//եHTMLʸ
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
	}
}
?>
<?php
//ڡեåʥץࡦСCopyrightɽ
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);
?>

</BODY>
</HTML>

